﻿#target photoshop
//
// Add a beveled mat to an image
//
// Flatten and copy image
// Resize to the target dimensions
// Add space for a mat around the image
// Add layer styles to simulate a beveled mat
// "360 ppi mat bevel" added to image layer to create the bevel around the mat window
// "360 ppi 2px stroke" added to solid fill layer to create the mat texture and 2px stroke
//

cTID = function(s) { return app.charIDToTypeID(s); };
sTID = function(s) { return app.stringIDToTypeID(s); };

var startHeight = activeDocument.height
var startWidth = activeDocument.width
var matThickness = 900
var matThicknessInch = 2
var boxLong=5400
var boxShort = 3960
var borderSizeInch = .2
var bottomSizeInch = 0.0
var targetLongInch = 20
var targetShortInch = 16
var targetLong = 7200
var targetShort = 5760
var imageSizeLong = 5400
var imageSizeShort = 3960

//
//==================== Landscape Optically Centered Framed - 2000 pixel wide ==============
//
function LandscapeOpticallyCenteredFramed_2000pixelwide() {
  // Duplicate
  function step1(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putEnumerated(cTID('Dcmn'), cTID('Ordn'), cTID('Frst'));
    desc1.putReference(cTID('null'), ref1);
    desc1.putString(cTID('Nm  '), "MattedImage-"+activeDocument.name);
    executeAction(cTID('Dplc'), desc1, dialogMode);
  };

  // Flatten Image
  function step2(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    executeAction(sTID('flattenImage'), undefined, dialogMode);
  };

  // Image Size
  function step3(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    // **********************   Added document aspect ration logic
    var resizeMode = 'Hght'
    var longSide = startHeight;
    var shortSide = startWidth;
    if(startWidth > startHeight) {
        resizeMode = 'Wdth';
        longSide = startWidth;
        shortSide = startHeight;
        }
        res = 360;

    targetLong = targetLongInch *360
    targetShort = targetShortInch * 360
    matThickness = 360*matThicknessInch;
    boxLong = targetLong - 2*matThickness - 2*borderSizeInch*360;
    boxShort = targetShort - 2*matThickness - 2*borderSizeInch*360;
    
    resizePcntLong = boxLong / longSide;
    resizePcntShort = boxShort / shortSide;
    resizePcnt = resizePcntLong;
    if( resizePcntShort < resizePcntLong ) {
        resizePcnt = resizePcntShort;
        }
    imageLongSide = resizePcnt * longSide;
    imageShortSide = resizePcnt * shortSide;
    
     // **********************  End of aspect ration logic
    desc1.putUnitDouble(cTID(resizeMode), cTID('#Pxl'), imageLongSide);
    desc1.putUnitDouble(cTID('Rslt'), cTID('#Rsl'), res);
    desc1.putBoolean(sTID("scaleStyles"), true);
    desc1.putBoolean(cTID('CnsP'), true);
    desc1.putEnumerated(cTID('Intr'), cTID('Intp'), cTID('Bcbc'));
    executeAction(sTID('imageSize'), desc1, dialogMode);
    //alert("Original document size size was "+startHeight+" by "+startWidth)
    newHeight = activeDocument.height
    newWidth = activeDocument.width
    //alert("Document size is "+newHeight+" by "+newWidth)
    
  };

  function addStroke(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putProperty(cTID('Prpr'), cTID('Lefx'));
    ref1.putEnumerated(cTID('Lyr '), cTID('Ordn'), cTID('Trgt'));
    desc1.putReference(cTID('null'), ref1);
    var desc2 = new ActionDescriptor();
    desc2.putUnitDouble(cTID('Scl '), cTID('#Prc'), 500);
    var desc3 = new ActionDescriptor();
    desc3.putBoolean(cTID('enab'), true);
    desc3.putEnumerated(cTID('Styl'), cTID('FStl'), cTID('InsF'));
    desc3.putEnumerated(cTID('PntT'), cTID('FrFl'), cTID('SClr'));
    desc3.putEnumerated(cTID('Md  '), cTID('BlnM'), cTID('Nrml'));
    desc3.putUnitDouble(cTID('Opct'), cTID('#Prc'), 100);
    desc3.putUnitDouble(cTID('Sz  '), cTID('#Pxl'), 3);
    var desc4 = new ActionDescriptor();
    desc4.putDouble(cTID('Rd  '), 0);
    desc4.putDouble(cTID('Grn '), 0);
    desc4.putDouble(cTID('Bl  '), 0);
    desc3.putObject(cTID('Clr '), sTID("RGBColor"), desc4);
    desc2.putObject(cTID('FrFX'), cTID('FrFX'), desc3);
    desc1.putObject(cTID('T   '), cTID('Lefx'), desc2);
    executeAction(cTID('setd'), desc1, dialogMode);
  };


function step35(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);

    var borderSize = borderSizeInch*2*72;
    
    var desc1 = new ActionDescriptor();
    desc1.putBoolean(cTID('Rltv'), true);
    desc1.putUnitDouble(cTID('Wdth'), cTID('#Rlt'), borderSize);
    desc1.putUnitDouble(cTID('Hght'), cTID('#Rlt'), borderSize);
    desc1.putEnumerated(cTID('Hrzn'), cTID('HrzL'), cTID('Cntr'));
    desc1.putEnumerated(cTID('Vrtc'), cTID('VrtL'), cTID('Cntr'));
    desc1.putEnumerated(sTID("canvasExtensionColorType"), sTID("canvasExtensionColorType"), cTID('Wht '));
    executeAction(sTID('canvasSize'), desc1, dialogMode);
  };

  function addBottom(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
      
    var bottomSize = bottomSizeInch*72;
    
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    desc1.putBoolean(cTID('Rltv'), true);
    desc1.putUnitDouble(cTID('Hght'), cTID('#Rlt'), bottomSize);
    desc1.putEnumerated(cTID('Vrtc'), cTID('VrtL'), cTID('Top '));
    desc1.putEnumerated(sTID("canvasExtensionColorType"), sTID("canvasExtensionColorType"), cTID('Wht '));
    executeAction(sTID('canvasSize'), desc1, dialogMode);
  };


  // Set
  function step4(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putProperty(cTID('Lyr '), cTID('Bckg'));
    desc1.putReference(cTID('null'), ref1);
    var desc2 = new ActionDescriptor();
    desc2.putUnitDouble(cTID('Opct'), cTID('#Prc'), 100);
    desc2.putEnumerated(cTID('Md  '), cTID('BlnM'), cTID('Nrml'));
    desc1.putObject(cTID('T   '), cTID('Lyr '), desc2);
    executeAction(cTID('setd'), desc1, dialogMode);
  };

  // Canvas Size
  function step5(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    desc1.putBoolean(cTID('Rltv'), true);
    desc1.putUnitDouble(cTID('Wdth'), cTID('#Pxl'), (matThickness*2));
    desc1.putUnitDouble(cTID('Hght'), cTID('#Pxl'), (matThickness*2));
    desc1.putEnumerated(cTID('Hrzn'), cTID('HrzL'), cTID('Cntr'));
    desc1.putEnumerated(cTID('Vrtc'), cTID('VrtL'), cTID('Cntr'));
    executeAction(sTID('canvasSize'), desc1, dialogMode);
  };

  // Canvas Size
  function step6(enabled, withDialog) {
   if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    
    var docHeight = activeDocument.height;
    var docWidth = activeDocument.width;
    var addW = 0.0;
    var addH = 0.0;
 
    imageSizeLong = imageLongSide + borderSizeInch*720 + matThicknessInch*720;
    imageSizeShort = imageShortSide + borderSizeInch*720 + matThicknessInch*720;
 
    // if vertical    
    if( docHeight >= docWidth) {
        addH = targetLong - imageSizeLong - bottomSizeInch*360;
        addW = targetShort - imageSizeShort;
        };
    // if horizontal
    if( docHeight < docWidth) {
        addH = targetShort - imageSizeShort - bottomSizeInch*360;
        addW = targetLong - imageSizeLong;
        };
    desc1.putBoolean(cTID('Rltv'), true);    
    desc1.putUnitDouble(cTID('Wdth'), cTID('#Pxl'), addW );
    desc1.putUnitDouble(cTID('Hght'), cTID('#Pxl'), addH );
    desc1.putEnumerated(cTID('Hrzn'), cTID('HrzL'), cTID('Cntr'));
    desc1.putEnumerated(cTID('Vrtc'), cTID('VrtL'), cTID('Cntr'));
    executeAction(sTID('canvasSize'), desc1, dialogMode);
  };
  
  // Make
  function step7(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putClass(cTID('Lyr '));
    desc1.putReference(cTID('null'), ref1);
    desc1.putBoolean(sTID("below"), true);
    executeAction(cTID('Mk  '), desc1, dialogMode);
  };

  // Fill
  function step8(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    desc1.putEnumerated(cTID('Usng'), cTID('FlCn'), cTID('Wht '));
    executeAction(cTID('Fl  '), desc1, dialogMode);
  };
  
  
  // Apply
  function step9(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putName(cTID('Styl'), "100 Pixel Frame V2");
    desc1.putReference(cTID('null'), ref1);
    var ref2 = new ActionReference();
    ref2.putEnumerated(cTID('Lyr '), cTID('Ordn'), cTID('Trgt'));
    desc1.putReference(cTID('T   '), ref2);
    executeAction(sTID('applyStyle'), desc1, dialogMode);
  };

  // Select
  function step10(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putName(cTID('Lyr '), "Layer 0");
    desc1.putReference(cTID('null'), ref1);
    desc1.putBoolean(cTID('MkVs'), false);
    executeAction(cTID('slct'), desc1, dialogMode);
  };

  // Apply
  function step11(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
     var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putName(cTID('Styl'), "360 ppi mat bevel");
    desc1.putReference(cTID('null'), ref1);
    var ref2 = new ActionReference();
    ref2.putEnumerated(cTID('Lyr '), cTID('Ordn'), cTID('Trgt'));
    desc1.putReference(cTID('T   '), ref2);
    executeAction(sTID('applyStyle'), desc1, dialogMode);
  };

  // Convert to Profile
  function step12(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    var ref1 = new ActionReference();
    ref1.putEnumerated(cTID('Dcmn'), cTID('Ordn'), cTID('Trgt'));
    desc1.putReference(cTID('null'), ref1);
    desc1.putString(cTID('T   '), "sRGB IEC61966-2.1");
    desc1.putEnumerated(cTID('Inte'), cTID('Inte'), cTID('Clrm'));
    desc1.putBoolean(cTID('MpBl'), true);
    desc1.putBoolean(cTID('Dthr'), true);
    desc1.putBoolean(cTID('Fltt'), true);
    desc1.putInteger(cTID('sdwM'), -1);
    if( activeDocument.mode == "DocumentMode.RGB" )
        if( activeDocument.colorProfileName != "sRGB IEC61966-2.1")
            executeAction(sTID('convertToProfile'), desc1, dialogMode);
            ;
  };

  // Convert Mode
  function step13(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    var desc1 = new ActionDescriptor();
    desc1.putInteger(cTID('Dpth'), 8);
    desc1.putBoolean(cTID('Mrge'), false);
    executeAction(sTID('convertMode'), desc1, dialogMode);
  };

// Convert to Smart Object
  function makeSmartObject(enabled, withDialog) {
    if (enabled != undefined && !enabled)
      return;
    var dialogMode = (withDialog ? DialogModes.ALL : DialogModes.NO);
    executeAction(sTID('newPlacedLayer'), undefined, dialogMode);
  };


  step1();      // Duplicate
  step2();      // Flatten Image
  step12();      // Convert to Profile
  step13();      // Convert Mode
  step3();      // Image Size
  step4();      // Make layer 0
  addStroke();  //Add 3 px stoke
  step2();       // Flatten again
  step35();    // Add border
  addBottom(); //Add bottom area for signature
  step4();      // Set
  makeSmartObject();  // convert to smart object
  step5();      // Canvas Size
  step6();      // Canvas Size
  step7();      // Make
  step8();      // Fill
  step9();      // Apply frame
  step10();      // Select
  step11();      // Apply
};



//=========================================
//                    LandscapeOpticallyCenteredFramed_2000pixelwide.main
//=========================================
//



LandscapeOpticallyCenteredFramed_2000pixelwide.main = function () {

  if( !(targetShortInch = prompt("What size (in inches) do you want the overall SHORT dimension?",targetShortInch) )  )
        return;

  if( !(targetLongInch = prompt("What size (in inches) do you want the overall LONG dimension?",targetLongInch) )  )
        return;

  if( !(matThicknessInch = prompt("How wide (in inches) do you want the mat surrounding the image?",matThicknessInch) )  )
        return;

  if( !(borderSizeInch = prompt("How wide do you want the border inset?",borderSizeInch)))
        return;

  if( !(bottomSizeInch = prompt("How much additional space (in inches) do you want along the bottom?",bottomSizeInch) )  )
        return;

  LandscapeOpticallyCenteredFramed_2000pixelwide();
};

LandscapeOpticallyCenteredFramed_2000pixelwide.main();

// EOF

"LandscapeOpticallyCenteredFramed_2000pixelwide.jsx"
// EOF
